package com.qboxus.tictic.activitesfragments.shoping.models;

import com.google.gson.annotations.SerializedName;
import com.qboxus.tictic.models.UserModel;

import org.jetbrains.annotations.NotNull;

import java.io.Serializable;
import java.util.ArrayList;

public class ProductModel implements Serializable {
    @SerializedName("Product")
     Product product;

    @SerializedName("ProductImage")
     ArrayList<ProductImage> productImage=new ArrayList<>();

    @SerializedName("ProductAttribute")
     ArrayList<ProductAttribute> productAttribute=new ArrayList<>();

    @SerializedName("User")
    UserModel user;

    @SerializedName("ProductFavourite")
    ProductFavourite ProductFavourite;

    Boolean isSelect=false;

    public  int count=0;

    public ProductModel (){
    }

    public ProductModel(Product product, ArrayList<ProductImage> productImage, ArrayList<ProductAttribute> productAttribute) {
        this.product = product;
        this.productImage = productImage;
        this.productAttribute = productAttribute;
    }

    public void clone(ProductModel productModel){
        this.product = new Product(productModel.product);

        for(ProductImage productImage1:productModel.getProductImage()){
            this.productImage.add(new ProductImage(productImage1));
        }
        for(ProductAttribute attribute:productModel.getProductAttribute()){
            this.productAttribute.add(new ProductAttribute(attribute));
        }

        this.ProductFavourite=productModel.ProductFavourite;
    }

    public Product getProduct() {
        return product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public ArrayList<ProductImage> getProductImage() {
        return productImage;
    }

    public void setProductImage(ArrayList<ProductImage> productImage) {
        this.productImage = productImage;
    }

    public ArrayList<ProductAttribute> getProductAttribute() {
        return productAttribute;
    }

    public void setProductAttribute(ArrayList<ProductAttribute> productAttribute) {
        this.productAttribute = productAttribute;
    }

    public ProductFavourite getProductFavouriteObject() {
        return ProductFavourite;
    }

    public void setProductFavouriteObject(ProductFavourite productFavouriteObject) {
        ProductFavourite = productFavouriteObject;
    }

    public Boolean getSelect() {
        return isSelect;
    }

    public void setSelect(Boolean select) {
        isSelect = select;
    }

    public UserModel getUser() {
        return user;
    }

    public void setUser(UserModel user) {
        this.user = user;
    }
}

